//Thread safe version of posix time functions


//******************************************************************************************************
//**** PROJECT HEADER FILES
//******************************************************************************************************
#include <OS.h>
#include "SafeTime.h"


//******************************************************************************************************
//**** GLOBAL VARIABLES AND CONSTANTS
//******************************************************************************************************
sem_id safe_time_semaphore;


//******************************************************************************************************
//**** FUNCTION DEFINITIONS
//******************************************************************************************************
bool InitSafeTime()
//Must be called to initialize the protection semaphore.  It will be deleted when the team quits.
{
	return ((safe_time_semaphore = create_sem(1,"SafeTime semaphore")) >= B_NO_ERROR);
}


void Safe_localtime(time_t source_timeval,struct tm* dest_brokendowntime)
//Takes a time value and calls localtime to get the broken down time format, which is copied to the
//destination tm structure.
{
	while(acquire_sem(safe_time_semaphore) != B_NO_ERROR)
		;

	struct tm* UnprotectedTm = localtime(&source_timeval);
	dest_brokendowntime->tm_sec = UnprotectedTm->tm_sec;
	dest_brokendowntime->tm_min = UnprotectedTm->tm_min;
	dest_brokendowntime->tm_hour = UnprotectedTm->tm_hour;
	dest_brokendowntime->tm_mday = UnprotectedTm->tm_mday;
	dest_brokendowntime->tm_mon = UnprotectedTm->tm_mon;
	dest_brokendowntime->tm_year = UnprotectedTm->tm_year;
	dest_brokendowntime->tm_wday = UnprotectedTm->tm_wday;
	dest_brokendowntime->tm_yday = UnprotectedTm->tm_yday;
	dest_brokendowntime->tm_isdst = UnprotectedTm->tm_isdst;
	dest_brokendowntime->tm_gmtoff = UnprotectedTm->tm_gmtoff;
	dest_brokendowntime->tm_zone = UnprotectedTm->tm_zone;

	release_sem(safe_time_semaphore);
}